/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * code generator gen_fx, build 138747.21028
 *                                                                            *
 * Portions Copyright (c) 1986-2011 mental images GmbH, Berlin, Germany.      *
 ******************************************************************************/

// Option settings:
//	annotation_map : default.axml
//	depth_test : false
//	depth_write : false
//	directx_version : 9
//	format : HLSL
//	fragment_shader_profile : ps_3_0
//	fx_header : #ifdef _MAX_...
//	pass_annotations : string Script = "Draw=Buffer;";
//	screen_space_vertices : true
//	shader_name : mia_physicalsky_1
//	shader_type : surface
//	technique_annotations : string Script = "Pass=P0;";
//	vertex_shader_profile : vs_3_0

#ifdef _MAX_
string ParamID = "0x003";
#endif

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOrder = "preprocess";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #

struct State {
    float3 position;
    float3 origin;
    float3 normal;
    float3 direction;
    float ray_length;
};

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT2_CTOR
#define __FLOAT2_CTOR
float2 __float2_ctor(float v)
{
    return v.xx;
}

#endif // __FLOAT2_CTOR

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT

#ifndef __BIT_SUBSET
#define __BIT_SUBSET
bool __bit_subset(uint a, uint b)
 {
    if (a >= 0x8000) {
        if (b < 0x8000)
            return false;
        a -= 0x8000;
    }
    if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        if (b < 0x4000)
            return false;
        a -= 0x4000;
    }
    if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        if (b < 0x2000)
            return false;
        a -= 0x2000;
    }
    if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        if (b < 0x1000)
            return false;
        a -= 0x1000;
    }
    if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        if (b < 0x0800)
            return false;
        a -= 0x0800;
    }
    if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        if (b < 0x0400)
            return false;
        a -= 0x0400;
    }
    if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        if (b < 0x0200)
            return false;
        a -= 0x0200;
    }
    if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        if (b < 0x0100)
            return false;
        a -= 0x0100;
    }
    if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        if (b < 0x0080)
            return false;
        a -= 0x0080;
    }
    if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        if (b < 0x0040)
            return false;
        a -= 0x0040;
    }
    if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        if (b < 0x0020)
            return false;
        a -= 0x0020;
    }
    if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        if (b < 0x0010)
            return false;
        a -= 0x0010;
    }
    if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        if (b < 0x0008)
            return false;
        a -= 0x0008;
    }
    if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        if (b < 0x0004)
            return false;
        a -= 0x0004;
    }
    if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        if (b < 0x0002)
            return false;
        a -= 0x0002;
    }
    if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        if (b < 0x0001)
            return false;
        a -= 0x0001;
    }
    if (b >= 0x0001) b -= 0x0001;
    return true;
}
#endif // __BIT_SUBSET

#ifndef __BIT_NOT
#define __BIT_NOT
int __bit_not(int a) {
    return 0xFFFF - a;
}
#endif // __BIT_NOT

#ifndef __BIT_AND
#define __BIT_AND
int __bit_and(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000; else res -= 0x8000;
    } else if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000; else res -= 0x4000;
    } else if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000; else res -= 0x2000;
    } else if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000; else res -= 0x1000;
    } else if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800; else res -= 0x0800;
    } else if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400; else res -= 0x0400;
    } else if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200; else res -= 0x0200;
    } else if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100; else res -= 0x0100;
    } else if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080; else res -= 0x0080;
    } else if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040; else res -= 0x0040;
    } else if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020; else res -= 0x0020;
    } else if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010; else res -= 0x0010;
    } else if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008; else res -= 0x0008;
    } else if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004; else res -= 0x0004;
    } else if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002; else res -= 0x0002;
    } else if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001; else res -= 0x0001;
    } else if (b >= 0x0001) b -= 0x0001;
    return res;
}
#endif // __BIT_AND

#ifndef __BIT_OR
#define __BIT_OR
int __bit_or(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000;
    } else if (b >= 0x8000) { b -= 0x8000; res += 0x8000; }
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000;
    } else if (b >= 0x4000) { b -= 0x4000; res += 0x4000; }
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000;
    } else if (b >= 0x2000) { b -= 0x2000; res += 0x2000; }
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000;
    } else if (b >= 0x1000) { b -= 0x1000; res += 0x1000; }
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800;
    } else if (b >= 0x0800) { b -= 0x0800; res += 0x0800; }
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400;
    } else if (b >= 0x0400) { b -= 0x0400; res += 0x0400; }
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200;
    } else if (b >= 0x0200) { b -= 0x0200; res += 0x0200; }
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100;
    } else if (b >= 0x0100) { b -= 0x0100; res += 0x0100; }
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080;
    } else if (b >= 0x0080) { b -= 0x0080; res += 0x0080; }
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040;
    } else if (b >= 0x0040) { b -= 0x0040; res += 0x0040; }
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020;
    } else if (b >= 0x0020) { b -= 0x0020; res += 0x0020; }
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010;
    } else if (b >= 0x0010) { b -= 0x0010; res += 0x0010; }
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008;
    } else if (b >= 0x0008) { b -= 0x0008; res += 0x0008; }
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004;
    } else if (b >= 0x0004) { b -= 0x0004; res += 0x0004; }
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002;
    } else if (b >= 0x0002) { b -= 0x0002; res += 0x0002; }
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001;
    } else if (b >= 0x0001) { b -= 0x0001; res += 0x0001; }
    return res;
}
#endif // __BIT_OR


//
// The following are free parameters of the shader
// that should be set by the application at runtime.
//
bool msl_mia_physicalsky_1_on
<
    string UIName = "On";
    string description = "activates / deactivates shader";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "on";
    string parameter_source = "mia_physicalsky_1";
> = true;
float msl_mia_physicalsky_1_multiplier
<
    string UIName = "Multiplier";
    string description = "Scales the lightness of the environment";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "multiplier";
    string parameter_source = "mia_physicalsky_1";
> = 0.025f;
float4 msl_mia_physicalsky_1_rgb_unit_conversion
<
    string UIName = "RGB Unit conversion";
    string description = "When not using logarithmic exposure, use this value to scale color intensities to lie in a manageable range";
    float4 UIMin = {0.0f,0.0f,0.0f,0.0f};
    float4 UIMax = {1.0f,1.0f,1.0f,1.0f};
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "rgb_unit_conversion";
    string parameter_source = "mia_physicalsky_1";
> = {0.000667f,0.000667f,0.000667f,1.0f};
float msl_mia_physicalsky_1_haze
<
    string UIName = "Haze";
    string description = "Sets the amount of haze in the air";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "haze";
    string parameter_source = "mia_physicalsky_1";
> = 0.5f;
float msl_mia_physicalsky_1_redblueshift
<
    string UIName = "Red/Blue tint";
    string description = "Lets you shift the color towards blue / red";
    float UIMin = -1.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "redblueshift";
    string parameter_source = "mia_physicalsky_1";
> = 0.0f;
float msl_mia_physicalsky_1_saturation
<
    string UIName = "Saturation";
    string description = "Lets you adjust the saturation of the sky. A value of 0 gives a grayscale sky, 1 is neutral and 2 boosts the colors";
    float UIMin = 0.0f;
    float UIMax = 2.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "saturation";
    string parameter_source = "mia_physicalsky_1";
> = 0.5f;
float msl_mia_physicalsky_1_horizon_height
<
    string UIName = "Horizon height";
    string description = "vertical position of the horizon";
    float UIMin = -3.0f;
    float UIMax = 3.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "horizon_height";
    string parameter_source = "mia_physicalsky_1";
> = 0.001f;
float msl_mia_physicalsky_1_horizon_blur
<
    string UIName = "Horizon blur";
    string description = "Sets the blurriness of the horizon. At 0, the horizon is completely sharp";
    float UIMin = 0.0f;
    float UIMax = 10.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "horizon_blur";
    string parameter_source = "mia_physicalsky_1";
> = 0.1f;
float4 msl_mia_physicalsky_1_ground_color
<
    string UIName = "Ground color";
    string description = "The color of the virtual ground plane";
    float4 UIMin = {0.0f,0.0f,0.0f,0.0f};
    float4 UIMax = {1.0f,1.0f,1.0f,1.0f};
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "ground_color";
    string parameter_source = "mia_physicalsky_1";
> = {0.4f,0.4f,0.4f,1.0f};
float4 msl_mia_physicalsky_1_night_color
<
    string UIName = "Night Color";
    string description = "The maximum darkest value that the sky can be";
    float4 UIMin = {0.0f,0.0f,0.0f,0.0f};
    float4 UIMax = {1.0f,1.0f,1.0f,1.0f};
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "night_color";
    string parameter_source = "mia_physicalsky_1";
> = {0.0f,0.0f,0.0f,1.0f};
float3 msl_mia_physicalsky_1_sun_direction
<
    string UIName = "Sun direction";
    string description = "A vector value that describes the position of the sun. The Y-component describes the horizontal height";
    float3 UIMin = {-1.0f,-1.0f,-1.0f};
    float3 UIMax = {1.0f,1.0f,1.0f};
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "sun_direction";
    string parameter_source = "mia_physicalsky_1";
> = {0.0f,0.229271f,0.418882f};
float msl_mia_physicalsky_1_sun_disk_intensity
<
    string UIName = "Sun disk intensity";
    string description = "The intensity of the visible sun disk";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "sun_disk_intensity";
    string parameter_source = "mia_physicalsky_1";
> = 0.01f;
float msl_mia_physicalsky_1_sun_disk_scale
<
    string UIName = "Sun disk scale";
    string description = "The size of the visible sun disk";
    float UIMin = 0.0f;
    float UIMax = 30.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "sun_disk_scale";
    string parameter_source = "mia_physicalsky_1";
> = 0.5f;
float msl_mia_physicalsky_1_sun_glow_intensity
<
    string UIName = "";
    string description = "";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "sun_glow_intensity";
    string parameter_source = "mia_physicalsky_1";
> = 1.0f;
bool msl_mia_physicalsky_1_y_is_up
<
    string UIName = "Y is up";
    string description = "Defines what direction is up";
    string NodeName = "mia_physicalsky_1";
    string UIMetaSLName = "y_is_up";
    string parameter_source = "mia_physicalsky_1";
>;
/*
	mia_physicalsky_1_ground_color:
		Color msl_mia_physicalsky_1_ground_color = float4(0.400000,0.400000,0.400000,1.000000)
	mia_physicalsky_1_haze:
		float msl_mia_physicalsky_1_haze = 0.500000
	mia_physicalsky_1_horizon_blur:
		float msl_mia_physicalsky_1_horizon_blur = 0.100000
	mia_physicalsky_1_horizon_height:
		float msl_mia_physicalsky_1_horizon_height = 0.001000
	mia_physicalsky_1_multiplier:
		float msl_mia_physicalsky_1_multiplier = 0.025000
	mia_physicalsky_1_night_color:
		Color msl_mia_physicalsky_1_night_color = float4(0.000000,0.000000,0.000000,1.000000)
	mia_physicalsky_1_on:
		bool msl_mia_physicalsky_1_on = true
	mia_physicalsky_1_redblueshift:
		float msl_mia_physicalsky_1_redblueshift = 0.000000
	mia_physicalsky_1_rgb_unit_conversion:
		Color msl_mia_physicalsky_1_rgb_unit_conversion = float4(0.000667,0.000667,0.000667,1.000000)
	mia_physicalsky_1_saturation:
		float msl_mia_physicalsky_1_saturation = 0.500000
	mia_physicalsky_1_sun_direction:
		float3 msl_mia_physicalsky_1_sun_direction = float3(0.000000,0.229271,0.418882)
	mia_physicalsky_1_sun_disk_intensity:
		float msl_mia_physicalsky_1_sun_disk_intensity = 0.010000
	mia_physicalsky_1_sun_disk_scale:
		float msl_mia_physicalsky_1_sun_disk_scale = 0.500000
	mia_physicalsky_1_sun_glow_intensity:
		float msl_mia_physicalsky_1_sun_glow_intensity = 1.000000
	mia_physicalsky_1_y_is_up:
		bool msl_mia_physicalsky_1_y_is_up
 */


//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//

float4x4 __ndc_to_camera : ProjectionInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_ndc : Projection
<
    string UIWidget = "none";
>;
bool __orthographic : Orthographic= false;
float4x4 __object_to_world : World
<
    string UIWidget = "none";
>;
float4x4 __object_to_camera : WorldView
<
    string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
    string UIWidget = "none";
>;

//
// The following are parameters representing
// non-varying non-state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4x4 __internal_to_light;
float4x4 __light_to_internal;
float4 __light_texture_coordinate[4];
float3 __light_texture_tangent_u[4];
float3 __light_texture_tangent_v[4];
float __wavelength_base[3];
float __wavelength_sample[3];
int __light_normal_mode;
float __light_scaling_factor;


//
// The App2vert structure defines the vertex attributes
// used by the vertex shader.
// The application should supply a vertex stream
// containing these elements.
//
struct App2vert
{
    float3 position : POSITION;
    float3 normal : NORMAL;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
    float4 hpos : POSITION;
    float3 position : TEXCOORD0;
    float3 normal : TEXCOORD1;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
    float4 hpos : POSITION1;
    float3 position : TEXCOORD0;
    float3 normal : TEXCOORD1;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
    App2vert vs_in)
{
    Vert2frag_out vs_out;
    vs_out.position = mul(float4(vs_in.position,1.0),__ndc_to_camera).xyz;
    vs_out.hpos = float4(vs_in.position,1.0);
    vs_out.normal = mul((float3x3)__camera_to_ndc,vs_in.normal);
    return vs_out;
}

//
// Declaration of final output type. For MRT, this is a struct.
//
typedef float4 FS_OUT;

int mia_physicalsky_X0000009_4029_172(
    inout State state,
    inout float3 msl_X0000106,
    in bool msl_X0000107,
    in float msl_X0000108)
{
    if(msl_X0000107)
    {
        float msl_X0000109 = msl_X0000106.z;
        msl_X0000106.z = msl_X0000106.y;
        msl_X0000106.y = msl_X0000109;
    }
    if(msl_X0000108 != 0.0f)
    {
        msl_X0000106.z -= msl_X0000108;
        msl_X0000106 = normalize(msl_X0000106);
    }
    return 0;
}

int mia_physicalsky_X0000007_4029_153(
    inout State state,
    inout float msl_X0000089,
    in float msl_X0000090)
{
    float msl_X0000091 = pow(msl_X0000089,3.0f);
    if(msl_X0000089 <= 1.0f)
    {
        float msl_X0000092 = msl_X0000090;
        msl_X0000092 -= 2.0f;
        msl_X0000092 /= 15.0f;
        if(msl_X0000092 < 0.0f)
        {
            msl_X0000092 = 0.0f;
        }
        if(msl_X0000092 > 1.0f)
        {
            msl_X0000092 = 1.0f;
        }
        msl_X0000092 = pow(msl_X0000092,3.0f);
        msl_X0000089 = ((msl_X0000089 * (1.0f - msl_X0000092)) + (msl_X0000091 * msl_X0000092));
    }
    return 0;
}

float nonZero(float f)
{
	return abs(f) < 1e-6 ? 1e-6 : f;
}

float mia_physicalsky_X0000003_4029_95(
    inout State state,
    in float3 msl_X0000035,
    in float3 msl_X0000036,
    in float msl_X0000037)
{
    float msl_X0000038 = dot(msl_X0000036,msl_X0000035);
    if(msl_X0000038 < 0.0f)
    {
        msl_X0000038 = 0.0f;
    }
    if(msl_X0000038 > 1.0f)
    {
        msl_X0000038 = (2.0f - msl_X0000038);
    }
    float msl_X0000039 = acos(msl_X0000038);
    float msl_X0000040 = nonZero(msl_X0000035.z);
    float msl_X0000041 = msl_X0000036.z;
    float msl_X0000042 = acos(msl_X0000041);
    float msl_X0000043 = (0.178721f * msl_X0000037) - 1.463037f;
    float msl_X0000044 = ((-0.355402f) * msl_X0000037) + 0.427494f;
    float msl_X0000045 = ((-0.022669f) * msl_X0000037) + 5.325056f;
    float msl_X0000046 = (0.120647f * msl_X0000037) - 2.577052f;
    float msl_X0000047 = ((-0.066967f) * msl_X0000037) + 0.370275f;
    float msl_X0000048 = ((1.0f + (msl_X0000043 * exp((msl_X0000044 / msl_X0000040)))) * ((1.0f + (msl_X0000045 * exp((msl_X0000046 * msl_X0000039)))) + ((msl_X0000047 * msl_X0000038) * msl_X0000038))) / ((1.0f + (msl_X0000043 * exp((msl_X0000044 / 1.0f)))) * ((1.0f + (msl_X0000045 * exp((msl_X0000046 * msl_X0000042)))) + ((msl_X0000047 * msl_X0000041) * msl_X0000041)));
    return msl_X0000048;
}

float3 mia_physicalsky_X0000004_4029_110(
    inout State state,
    in float3 msl_X0000049,
    in float3 msl_X0000050,
    in float msl_X0000051,
    in float msl_X0000052)
{
    float3 msl_X0000053;
    float msl_X0000054;
    float msl_X0000055;
    float msl_X0000056;
    float msl_X0000057;
    float msl_X0000058;
    float msl_X0000059 = dot(msl_X0000050,msl_X0000049);
    if(msl_X0000059 > 1.0f)
    {
        msl_X0000059 = (2.0f - msl_X0000059);
    }
    float msl_X0000060 = acos(msl_X0000059);
    float msl_X0000061 = nonZero(msl_X0000049.z);
    float msl_X0000062 = msl_X0000050.z;
    float msl_X0000063 = acos(msl_X0000062);
    float msl_X0000064 = msl_X0000051 * msl_X0000051;
    float msl_X0000065 = msl_X0000063 * msl_X0000063;
    float msl_X0000066 = msl_X0000065 * msl_X0000063;
    float msl_X0000067 = ((((((0.001650f * msl_X0000066) - (0.003742f * msl_X0000065)) + (0.002088f * msl_X0000063)) + 0.0f) * msl_X0000064) + ((((((-0.029028f) * msl_X0000066) + (0.063773f * msl_X0000065)) - (0.032020f * msl_X0000063)) + 0.003948f) * msl_X0000051)) + ((((0.116936f * msl_X0000066) - (0.211960f * msl_X0000065)) + (0.060523f * msl_X0000063)) + 0.258852f);
    float msl_X0000068 = ((((((0.002759f * msl_X0000066) - (0.006105f * msl_X0000065)) + (0.003162f * msl_X0000063)) + 0.0f) * msl_X0000064) + ((((((-0.042149f) * msl_X0000066) + (0.089701f * msl_X0000065)) - (0.041536f * msl_X0000063)) + 0.005158f) * msl_X0000051)) + ((((0.153467f * msl_X0000066) - (0.267568f * msl_X0000065)) + (0.066698f * msl_X0000063)) + 0.266881f);
    msl_X0000053.y = msl_X0000052;
    msl_X0000054 = (((-0.019257f) * msl_X0000051) - (0.29f - (pow(msl_X0000062,0.5f) * 0.09f)));
    msl_X0000055 = (((-0.066513f) * msl_X0000051) + 0.000818f);
    msl_X0000056 = (((-0.000417f) * msl_X0000051) + 0.212479f);
    msl_X0000057 = (((-0.064097f) * msl_X0000051) - 0.898875f);
    msl_X0000058 = (((-0.003251f) * msl_X0000051) + 0.045178f);
    float msl_X0000069 = ((1.0f + (msl_X0000054 * exp((msl_X0000055 / msl_X0000061)))) * ((1.0f + (msl_X0000056 * exp((msl_X0000057 * msl_X0000060)))) + ((msl_X0000058 * msl_X0000059) * msl_X0000059))) / ((1.0f + (msl_X0000054 * exp((msl_X0000055 / 1.0f)))) * ((1.0f + (msl_X0000056 * exp((msl_X0000057 * msl_X0000063)))) + ((msl_X0000058 * msl_X0000062) * msl_X0000062)));
    msl_X0000054 = (((-0.016698f) * msl_X0000051) - 0.260787f);
    msl_X0000055 = (((-0.094958f) * msl_X0000051) + 0.009213f);
    msl_X0000056 = (((-0.007928f) * msl_X0000051) + 0.210230f);
    msl_X0000057 = (((-0.044050f) * msl_X0000051) - 1.653694f);
    msl_X0000058 = (((-0.010922f) * msl_X0000051) + 0.052919f);
    float msl_X0000070 = ((1.0f + (msl_X0000054 * exp((msl_X0000055 / msl_X0000061)))) * ((1.0f + (msl_X0000056 * exp((msl_X0000057 * msl_X0000060)))) + ((msl_X0000058 * msl_X0000059) * msl_X0000059))) / ((1.0f + (msl_X0000054 * exp((msl_X0000055 / 1.0f)))) * ((1.0f + (msl_X0000056 * exp((msl_X0000057 * msl_X0000063)))) + ((msl_X0000058 * msl_X0000062) * msl_X0000062)));
    float msl_X0000071 = 1.0f;
    msl_X0000069 = (msl_X0000067 * ((msl_X0000069 * msl_X0000071) + (1.0f - msl_X0000071)));
    msl_X0000070 = (msl_X0000068 * ((msl_X0000070 * msl_X0000071) + (1.0f - msl_X0000071)));
    msl_X0000053.x = ((msl_X0000069 / msl_X0000070) * msl_X0000053.y);
    msl_X0000053.z = ((((1.0f - msl_X0000069) - msl_X0000070) / msl_X0000070) * msl_X0000053.y);
    return msl_X0000053;
}

float4 mia_physicalsky_X0000005_4029_134(
    inout State state,
    in float3 msl_X0000072,
    in float3 msl_X0000073,
    in float msl_X0000074)
{
    float4 msl_X0000075 = float4(0.0f,0.0f,0.0f,0.0f);
    float msl_X0000076 = acos(msl_X0000072.z);
    float msl_X0000077 = (0.444444f - (msl_X0000074 / 120.0f)) * (3.14159265358979323846f - (2.0f * msl_X0000076));
    float msl_X0000078 = (((1000.0f * ((4.0453f * msl_X0000074) - 4.9710f)) * tan(msl_X0000077)) - (0.2155f * msl_X0000074)) + 2.4192f;
    msl_X0000078 *= mia_physicalsky_X0000003_4029_95(state,msl_X0000073,msl_X0000072,msl_X0000074);
    float3 msl_X0000079 = mia_physicalsky_X0000004_4029_110(state,msl_X0000073,msl_X0000072,msl_X0000074,msl_X0000078);
    msl_X0000075.r = (((3.241f * msl_X0000079.x) - (1.537f * msl_X0000079.y)) - (0.499f * msl_X0000079.z));
    msl_X0000075.g = ((((-0.969f) * msl_X0000079.x) + (1.876f * msl_X0000079.y)) + (0.042f * msl_X0000079.z));
    msl_X0000075.b = (((0.056f * msl_X0000079.x) - (0.204f * msl_X0000079.y)) + (1.057f * msl_X0000079.z));
    msl_X0000075 *= __float4_ctor(3.14159265358979323846f);
    msl_X0000075.a = 0.0f;
    return msl_X0000075;
}

float4 mia_physicalsky_X0000008_4029_158(
    inout State state,
    in float3 msl_X0000093,
    in float msl_X0000094)
{
    float4 msl_X0000095 = float4(0.0f,0.0f,0.0f,0.0f);
    float4 msl_X0000096 = float4(12.0f,8.5f,0.9f,0.0f);
    float4 msl_X0000097 = float4(0.610f,0.550f,0.470f,0.0f);
    float4 msl_X0000098 = float4(129074.710938f,128042.117188f,117587.0625f,0.0f);
    if(msl_X0000093.z > 0.0f)
    {
        float msl_X0000099 = 1.0f / (msl_X0000093.z + (0.15f * pow((93.885f - ((acos(msl_X0000093.z) * 180.0f) / 3.14159265358979323846f)),(-1.253f))));
        float msl_X0000100 = (0.04608f * msl_X0000094) - 0.04586f;
        float msl_X0000101 = 1.3f;
        float4 msl_X0000102;
        float4 msl_X0000103;
        float4 msl_X0000104;
        msl_X0000102.r = exp((((-msl_X0000099) * msl_X0000100) * pow(msl_X0000097.r,(-msl_X0000101))));
        msl_X0000102.g = exp((((-msl_X0000099) * msl_X0000100) * pow(msl_X0000097.g,(-msl_X0000101))));
        msl_X0000102.b = exp((((-msl_X0000099) * msl_X0000100) * pow(msl_X0000097.b,(-msl_X0000101))));
        float msl_X0000105 = 0.0035f;
        msl_X0000103.r = exp((((-msl_X0000099) * msl_X0000096.r) * msl_X0000105));
        msl_X0000103.g = exp((((-msl_X0000099) * msl_X0000096.g) * msl_X0000105));
        msl_X0000103.b = exp((((-msl_X0000099) * msl_X0000096.b) * msl_X0000105));
        msl_X0000104.r = exp((((-msl_X0000099) * 0.008735f) * pow(msl_X0000097.r,(-4.08f))));
        msl_X0000104.g = exp((((-msl_X0000099) * 0.008735f) * pow(msl_X0000097.g,(-4.08f))));
        msl_X0000104.b = exp((((-msl_X0000099) * 0.008735f) * pow(msl_X0000097.b,(-4.08f))));
        msl_X0000095.r = (((msl_X0000104.r * msl_X0000102.r) * msl_X0000103.r) * msl_X0000098.r);
        msl_X0000095.g = (((msl_X0000104.g * msl_X0000102.g) * msl_X0000103.g) * msl_X0000098.g);
        msl_X0000095.b = (((msl_X0000104.b * msl_X0000102.b) * msl_X0000103.b) * msl_X0000098.b);
    }
    return msl_X0000095;
}

int mia_physicalsky_X0000000_4029_68(
    inout State state,
    inout float msl_X0000011,
    inout float msl_X0000012,
    in float msl_X0000013,
    in float msl_X0000014)
{
    float msl_X0000015 = (2.0f * msl_X0000013) - 1.0f;
    float msl_X0000016 = (2.0f * msl_X0000014) - 1.0f;
    if((msl_X0000015 == 0.0f) && (msl_X0000016 == 0.0f))
    {
        msl_X0000012 = 0.0f;
        msl_X0000011 = 0.0f;
    }
    else
    {
        if(msl_X0000015 > (-msl_X0000016))
        {
            if(msl_X0000015 > msl_X0000016)
            {
                msl_X0000011 = msl_X0000015;
                msl_X0000012 = (0.785398f * (1.0f + (msl_X0000016 / msl_X0000015)));
            }
            else
            {
                msl_X0000011 = msl_X0000016;
                msl_X0000012 = (0.785398f * (3.0f - (msl_X0000015 / msl_X0000016)));
            }
        }
        else
        {
            if(msl_X0000015 < msl_X0000016)
            {
                msl_X0000011 = (-msl_X0000015);
                msl_X0000012 = (0.785398f * (5.0f + (msl_X0000016 / msl_X0000015)));
            }
            else
            {
                msl_X0000011 = (-msl_X0000016);
                msl_X0000012 = (0.785398f * (7.0f - (msl_X0000015 / msl_X0000016)));
            }
        }
    }
    return 0;
}

int mia_physicalsky_X0000001_4029_75(
    inout State state,
    inout float3 msl_X0000017,
    in float3 msl_X0000018,
    in float msl_X0000019,
    in float msl_X0000020,
    in float msl_X0000021)
{
    float3 msl_X0000022;
    float3 msl_X0000023;
    float3 msl_X0000024 = mul((float3x3)(__object_to_camera),msl_X0000018);
    if(abs(msl_X0000024.x) < abs(msl_X0000024.y))
    {
        msl_X0000022.x = 0.0f;
        msl_X0000022.y = (-msl_X0000024.z);
        msl_X0000022.z = msl_X0000024.y;
    }
    else
    {
        msl_X0000022.x = msl_X0000024.z;
        msl_X0000022.y = 0.0f;
        msl_X0000022.z = (-msl_X0000024.x);
    }
    msl_X0000022 = (mul(msl_X0000022,(float3x3)(__object_to_camera)));
    if(length(msl_X0000022) == 0.0f)
    {
        if(abs(msl_X0000018.x) < abs(msl_X0000018.y))
        {
            msl_X0000022.x = 0.0f;
            msl_X0000022.y = (-msl_X0000018.z);
            msl_X0000022.z = msl_X0000018.y;
        }
        else
        {
            msl_X0000022.x = msl_X0000018.z;
            msl_X0000022.y = 0.0f;
            msl_X0000022.z = (-msl_X0000018.x);
        }
    }
    msl_X0000022 = normalize(msl_X0000022);
    msl_X0000023 = cross(msl_X0000018,msl_X0000022);
    msl_X0000017 = (((msl_X0000019 * msl_X0000022) + (msl_X0000020 * msl_X0000023)) + (msl_X0000021 * msl_X0000018));
    return 0;
}

int mia_physicalsky_X0000002_4029_84(
    inout State state,
    inout float3 msl_X0000025,
    in float3 msl_X0000026,
    in float2 msl_X0000027)
{
    float msl_X0000028 = 0.0001f;
    float msl_X0000029 = 0.0f;
    float msl_X0000030 = 0.0f;
    mia_physicalsky_X0000000_4029_68(state,msl_X0000029,msl_X0000030,msl_X0000027.x,msl_X0000027.y);
    float msl_X0000031 = msl_X0000029 * cos(msl_X0000030);
    float msl_X0000032 = msl_X0000029 * sin(msl_X0000030);
    float msl_X0000033 = (1.0f - (msl_X0000031 * msl_X0000031)) - (msl_X0000032 * msl_X0000032);
    float msl_X0000034;
    if(msl_X0000033 > 0.0f)
    {
        msl_X0000034 = sqrt(msl_X0000033);
    }
    else
    {
        msl_X0000034 = 0.0f;
    }
    mia_physicalsky_X0000001_4029_75(state,msl_X0000025,msl_X0000026,msl_X0000031,msl_X0000032,msl_X0000034);
    return 0;
}

float4 mia_physicalsky_X0000006_4029_143(
    inout State state,
    in float3 msl_X0000080,
    in float msl_X0000081)
{
    float4 msl_X0000082 = float4(0.0f,0.0f,0.0f,0.0f);
    float3 msl_X0000083 = float3(0.0f,0.0f,1.0f);
    float3 msl_X0000084 = msl_X0000083;
    float3 msl_X0000085 = msl_X0000080;
    if(msl_X0000085.z < 0.001f)
    {
        msl_X0000085.z = 0.001f;
        msl_X0000085 = normalize(msl_X0000085);
    }
    float2 msl_X0000086 = float2(0.0f,0.0f);
    float3 msl_X0000087 = float3(0.0f,0.0f,0.0f);
    float4 msl_X0000088 = float4(0.0f,0.0f,0.0f,0.0f);
    msl_X0000086 = float2(0.000000f,0.000000f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.125000f,0.062500f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.250000f,0.031250f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.375000f,0.093750f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.500000f,0.015625f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.625000f,0.078125f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.750000f,0.046875f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000086 = float2(0.875000f,0.109375f);
    mia_physicalsky_X0000002_4029_84(state,msl_X0000087,msl_X0000083,msl_X0000086);
    msl_X0000088 = mia_physicalsky_X0000005_4029_134(state,msl_X0000085,msl_X0000087,msl_X0000081);
    msl_X0000082 += msl_X0000088;
    msl_X0000082 /= __float4_ctor(8.0f);
    return msl_X0000082;
}

int mia_physicalsky_X0000010_4029_177(
    inout State state,
    inout float4 msl_X0000110,
    in float msl_X0000111,
    in float msl_X0000112)
{
    float4 msl_X0000113 = float4(0.212671f,0.715160f,0.072169f,0.0f);
    float msl_X0000114 = ((msl_X0000110.r * msl_X0000113.r) + (msl_X0000110.g * msl_X0000113.g)) + (msl_X0000110.b * msl_X0000113.b);
    if(msl_X0000110.r < 0.0f)
    {
        msl_X0000110.r = 0.0f;
    }
    if(msl_X0000110.g < 0.0f)
    {
        msl_X0000110.g = 0.0f;
    }
    if(msl_X0000110.b < 0.0f)
    {
        msl_X0000110.b = 0.0f;
    }
    if(msl_X0000111 <= 0.0f)
    {
        msl_X0000110.r = (msl_X0000110.g = (msl_X0000110.b = msl_X0000114));
    }
    else
    {
        msl_X0000110 = ((msl_X0000110 * msl_X0000111) + __float4_ctor((msl_X0000114 * (1.0f - msl_X0000111))));
        if(msl_X0000111 > 1.0f)
        {
            if(msl_X0000110.r < 0.0f)
            {
                msl_X0000110.r = 0.0f;
            }
            if(msl_X0000110.g < 0.0f)
            {
                msl_X0000110.g = 0.0f;
            }
            if(msl_X0000110.b < 0.0f)
            {
                msl_X0000110.b = 0.0f;
            }
        }
    }
    msl_X0000110.r *= (1.0f + msl_X0000112);
    msl_X0000110.b *= (1.0f - msl_X0000112);
    return 0;
}

int mia_physicalsky_main_4029_16(
    inout State state,
    bool msl_on,
    float msl_multiplier,
    float4 msl_rgb_unit_conversion,
    float msl_haze,
    float msl_redblueshift,
    float msl_saturation,
    float msl_horizon_height,
    float msl_horizon_blur,
    float4 msl_ground_color,
    float4 msl_night_color,
    float3 msl_sun_direction,
    float msl_sun_disk_intensity,
    float msl_sun_disk_scale,
    float msl_sun_glow_intensity,
    bool msl_y_is_up,
    out float4 msl_result)
{
    {
        msl_result = float4(0.0f,0.0f,0.0f,0.0f);
        float3 msl_X0000115 = mul((state.direction),(float3x3)(__camera_to_world));
        float msl_X0000116 = msl_horizon_height / 10.0f;
        mia_physicalsky_X0000009_4029_172(state,msl_X0000115,msl_y_is_up,msl_X0000116);
        float msl_X0000117 = msl_saturation;
        float msl_X0000118 = 2.0f + msl_haze;
        if(msl_X0000118 < 2.0f)
        {
            msl_X0000118 = 2.0f;
        }
        mia_physicalsky_X0000007_4029_153(state,msl_X0000117,msl_X0000118);
        float4 msl_X0000119 = msl_rgb_unit_conversion;
        if(msl_X0000119.r < 0.0f)
        {
            msl_X0000119.r = (msl_X0000119.g = (msl_X0000119.b = 0.000012f));
        }
        msl_X0000119 *= __float4_ctor(msl_multiplier);
        if(!((msl_multiplier <= 0.0f) || (!msl_on)))
        {
            float msl_X0000120 = msl_X0000115.z;
            if(msl_X0000115.z < 0.001f)
            {
                msl_X0000115.z = 0.001f;
                msl_X0000115 = normalize(msl_X0000115);
            }
            float3 msl_X0000121 = msl_sun_direction;
            msl_X0000121 = normalize(msl_X0000121);
            mia_physicalsky_X0000009_4029_172(state,msl_X0000121,msl_y_is_up,msl_X0000116);
            float msl_X0000122 = 1.0f;
            float msl_X0000123 = 1.0f;
            if(msl_X0000121.z < 0.001f)
            {
                if(msl_X0000121.z < 0.0f)
                {
                    msl_X0000122 = (1.0f + msl_X0000121.z);
                }
                msl_X0000121.z = 0.001f;
                msl_X0000121 = normalize(msl_X0000121);
            }
            float4 msl_X0000124 = mia_physicalsky_X0000005_4029_134(state,msl_X0000121,msl_X0000115,msl_X0000118);
            if(msl_X0000122 < 1.0f)
            {
                msl_X0000124.r *= msl_X0000122;
                msl_X0000124.g *= msl_X0000122;
                msl_X0000124.b *= msl_X0000122;
            }
            float4 msl_X0000125 = mia_physicalsky_X0000008_4029_158(state,msl_X0000121,msl_X0000118);
            if((msl_sun_disk_intensity > 0.0f) && (msl_sun_disk_scale > 0.0f))
            {
                float msl_X0000126 = acos(dot(msl_X0000115,msl_X0000121));
                float msl_X0000127 = (0.00465f * msl_sun_disk_scale) * 10.0f;
                if(msl_X0000126 < msl_X0000127)
                {
                    float msl_X0000128 = (1.0f - (msl_X0000126 / msl_X0000127)) * 10.0f;
                    msl_X0000128 = (((pow((msl_X0000128 / 10.0f),3.0f) * 2.0f) * msl_sun_glow_intensity) + ((smoothstep(8.5f,(9.5f + (msl_X0000118 / 50.0f)),msl_X0000128) * 100.0f) * msl_sun_disk_intensity));
                    msl_X0000124 += (msl_X0000125 * msl_X0000128);
                }
            }
            float4 msl_X0000129 = float4(0.0f,0.0f,0.0f,0.0f);
            msl_X0000129.r = (msl_X0000124.r * msl_X0000119.r);
            msl_X0000129.g = (msl_X0000124.g * msl_X0000119.g);
            msl_X0000129.b = (msl_X0000124.b * msl_X0000119.b);
            if(msl_X0000120 <= 0.0f)
            {
                float4 msl_X0000130 = float4(0.0f,0.0f,0.0f,0.0f);
                float msl_X0000131 = state.ray_length;
                float3 msl_X0000132 = mul((state.direction),(float3x3)(__camera_to_world));
                float3 msl_X0000133 = (mul(float4(state.position,1.0f),(__camera_to_world))).xyz;
                if(msl_X0000120 < 0.0f)
                {
                    msl_X0000131 = ((-msl_X0000133.z) / msl_X0000120);
                }
                else
                {
                    msl_X0000131 = 10000000000.0f;
                }
                float msl_X0000134 = msl_X0000131;
                float3 msl_X0000135 = msl_X0000133 + (msl_X0000132 * msl_X0000131);
                float3 msl_X0000136 = float3(0.0f,0.0f,1.0f);
                float3 msl_X0000137 = float3(0.0f,0.0f,1.0f);
                float4 msl_X0000138 = msl_ground_color;
                float msl_X0000139 = 2.0f + msl_haze;
                if(msl_X0000139 < 2.0f)
                {
                    msl_X0000139 = 2.0f;
                }
                msl_X0000130 = mia_physicalsky_X0000006_4029_143(state,msl_X0000121,msl_X0000139);
                msl_X0000138 *= ((msl_X0000130 + (msl_X0000125 * msl_X0000121.z)) * msl_X0000119);
                float msl_X0000140 = msl_horizon_blur / 10.0f;
                if(msl_X0000140 > 0.0f)
                {
                    float msl_X0000141 = -msl_X0000120;
                    msl_X0000141 /= msl_X0000140;
                    if(msl_X0000141 > 1.0f)
                    {
                        msl_X0000141 = 1.0f;
                    }
                    msl_X0000141 = smoothstep(0.0f,1.0f,msl_X0000141);
                    msl_X0000129 = ((msl_X0000129 * (1.0f - msl_X0000141)) + (msl_X0000138 * msl_X0000141));
                    msl_X0000123 = (1.0f - msl_X0000141);
                }
                else
                {
                    msl_X0000129 = msl_X0000138;
                    msl_X0000123 = 0.0f;
                }
            }
            mia_physicalsky_X0000010_4029_177(state,msl_X0000129,msl_X0000117,msl_redblueshift);
            msl_result = msl_X0000129;
            if(msl_X0000123 > 0.0f)
            {
                float4 msl_X0000142 = msl_night_color;
                msl_X0000142 *= __float4_ctor(msl_X0000123);
                if(msl_result.r < msl_X0000142.r)
                {
                    msl_result.r = msl_X0000142.r;
                }
                if(msl_result.g < msl_X0000142.g)
                {
                    msl_result.g = msl_X0000142.g;
                }
                if(msl_result.b < msl_X0000142.b)
                {
                    msl_result.b = msl_X0000142.b;
                }
            }
            float msl_X0000143 = 1.0f;
            float4 msl_X0000144 = float4(0.0f,0.0f,0.0f,0.0f);
            msl_X0000144.r = (msl_result.r * msl_X0000143);
            msl_X0000144.g = (msl_result.g * msl_X0000143);
            msl_X0000144.b = (msl_result.b * msl_X0000143);
            float msl_X0000145 = 45.5f;
            float msl_X0000146 = -4.725f;
            float msl_X0000147 = pow(10.0f,msl_X0000146) * 5.5f;
            float msl_X0000148 = 2.0f;
            float msl_X0000149 = msl_X0000147 * 3.0f;
            msl_X0000147 *= 3.14159265358979323846f;
            if(msl_X0000144.r >= 0.0f)
            {
            }
            else
            {
                msl_X0000144.r = 0.0f;
            }
            if(msl_X0000144.g >= 0.0f)
            {
            }
            else
            {
                msl_X0000144.g = 0.0f;
            }
            if(msl_X0000144.b >= 0.0f)
            {
            }
            else
            {
                msl_X0000144.b = 0.0f;
            }
            msl_result.r = msl_X0000144.r;
            msl_result.g = msl_X0000144.g;
            msl_result.b = msl_X0000144.b;
        }
        msl_result.a = 1.0f;
    }
    return 0;
}

//
// The following method is the root function of the shader graph
//
float4 mia_physicalsky_1_eval(State state, out FS_OUT eval_out)
{
    // primary output: 
    float4 msl_result;
    mia_physicalsky_main_4029_16(state,msl_mia_physicalsky_1_on,msl_mia_physicalsky_1_multiplier,msl_mia_physicalsky_1_rgb_unit_conversion,msl_mia_physicalsky_1_haze,msl_mia_physicalsky_1_redblueshift,msl_mia_physicalsky_1_saturation,msl_mia_physicalsky_1_horizon_height,msl_mia_physicalsky_1_horizon_blur,msl_mia_physicalsky_1_ground_color,msl_mia_physicalsky_1_night_color,msl_mia_physicalsky_1_sun_direction,msl_mia_physicalsky_1_sun_disk_intensity,msl_mia_physicalsky_1_sun_disk_scale,msl_mia_physicalsky_1_sun_glow_intensity,msl_mia_physicalsky_1_y_is_up,msl_result);
    eval_out = msl_result;
    return msl_result;
}

//
// This function is the main method of the fragment shader.
// It initializes the values in the state structure
// that are used by nodes in the shader graph
// and produces the final result of the shader.
//
FS_OUT fragment_main(
    Vert2frag_in fs_in) : COLOR
{
    State state;
    state.position = fs_in.position;
    state.normal = normalize(fs_in.normal);
    state.origin = __orthographic ? float3(state.position.x, state.position.y, 0) : 0;
    state.ray_length = __orthographic ? abs(state.position.z) : length(state.position);
    state.direction = __orthographic ? float3(0.0,0.0,-1.0) : state.position/state.ray_length;

    FS_OUT eval_out;  // multiple shader outputs
    float4 primary_out;  // primary shader output
    primary_out = mia_physicalsky_1_eval(state,eval_out);
    FS_OUT fs_out;
    fs_out = primary_out;
    return fs_out;
}

//
// The following define the default technique and pass of the effect.
//
technique T0
<
    string Script = "Pass=P0;";
>
{
    pass P0
    <
    string Script = "Draw=Buffer;";
        >
        {
            VertexShader = compile vs_3_0 vertex_main();
            PixelShader  = compile ps_3_0 fragment_main();
        }
    }

